# to autoload this file
proc m2Menu.tcl {} {}

#===========================================================================
#  M2 menu  #
#===========================================================================
proc m2Menu {} {}

menu::buildProc m2Menu menu::buildM2

proc menu::buildM2 {} {
    global m2Menu
    set menulst [list \
      "<B/0openWorkFiles" \
      "<B/EfindNextError" \
      "(-" \
      "<B/1launchShellAndSimulate" \
      "<B/2launchShell" \
      "(-" \
      "<B/GnextPlaceholder" \
      "<I<B/GprevPlaceholder" \
      "<U<B/MselectLine" \
      "(-" \
      "<B/KcommentSelection" \
      "<I<B/KuncommentSelection" \
      "<B/AwrapComment" \
      "<U<B/AwrapText" \
      "<B/3textToStructuralMark" \
      "<B/4textToSectionMark" \
      "(-" \
      "DefToMod" \
      "MakeProjectFile" \
      "<E<U/FautoEditCompilerFlags" \
      ]
    set submenulst	[list \
      "CASE" \
      "FOR" \
      "FROM IMPORT" \
      "IF" \
      "if on one line" \
      "LOOP" \
      "PROCEDURE" \
      "REPEAT" \
      "WHILE" \
      "WITH" \
      "(-" \
      "New DEFINITION Module" \
      "New IMPLEMENTATION Module" \
      "New Program MODULE" \
      ] 
    lappend menulst [list Menu -n templates -m -p dispatchSubMenuCmds ${submenulst}]
    lappend menulst \
      "(-" \
      "configureLaunching" \
      "(-" \
      "m2Help"
    # Only use these bindings for M2 mode
    return [list build $menulst [list dispatchMenuCmds -M M2] "" $m2Menu]
}

menu::buildSome m2Menu

proc dispatchMenuCmds {menu cmd} {
    if {[regexp {([^-]+)([-]*.*)} $cmd ]} then {
	regsub -- {([^-]+)([-]*.*)} $cmd "\\1" cmd
    }
    if {"$cmd" == "configureLaunching"} then {
	configureLaunching 1 1
    } else {
	$cmd
    }
}


proc dispatchSubMenuCmds {menu cmd} {
    set cmd [string trim $cmd]
    # set cmd [MinorizeStringBeg $cmd]
    regsub -all -- {[ ]+} $cmd "" cmd
    set cmd "smcmd$cmd"
    $cmd
}


# for M2 menu only
proc openWorkFiles {} {
    M2::openWorkFiles
}


# Reporting that end of this script has been reached
message "m2Menu.tcl for Programing in Modula-2 loaded"
if {$installDebugFlag} then {
    alertnote "m2Menu.tcl for Programing in Modula-2 loaded"
}
